<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

	
class XenCentral_AdServer_AlertHandler_Banner extends XenForo_AlertHandler_Abstract
{
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		$allBanners=$this->_getBannerModel()->getAllBannersFromCache();

		foreach($allBanners AS $bannerId=>$banner) {
			if(!in_array($bannerId, $contentIds)) {
				unset($allBanners[$bannerId]);
			}
		}

		return $allBanners;
	}

	public function _prepareBanner(array $item, array $viewingUser)
	{
		/*$item['extra']=unserialize($item['extra_data']);

		unset($item['extra_data']);*/
		
		return $item;
	}

	/**
	 * @return XenCentral_AdServer_Model_Banner
	 */
	protected function _getBannerModel()
	{
		static $_model;

		if($_model===null)
		{
			$_model=XenForo_Model::create('XenCentral_AdServer_Model_Banner');
		}

		return $_model;
	}

	/**
	 * @return XenCentral_AdServer_Model_Notification
	 */
	protected function _getNotificationModel()
	{
		static $_model;

		if($_model===null)
		{
			$_model=XenForo_Model::create('XenCentral_AdServer_Model_Notification');
		}

		return $_model;
	}

	protected function _prepareAlertAfterAction(array $item, $content, array $viewingUser)
	{
		$item=parent::_prepareAlertAfterAction($item, $content, $viewingUser);

		if (empty($item['action'])) {
			$type = '';
		} else {
			$type = $item['action'];
		}

		$notificationModel = $this->_getNotificationModel();

		if ($notificationModel->isAdminNotification($type)) {
			$link = XenForo_Link::buildAdminLink('full:xcas/banner/edit', $item['content']);
			$target="_blank";
		} else if ($notificationModel->isUserNotification($type)) {
			$link = XenForo_Link::buildPublicLink('full:ads');
			$target = "_self";
		} else {
			throw new XenForo_Exception('Unknown banner alert action - ' . $type);
		}

		$message = new XenForo_Phrase('xcas_alert_text_' . $type, $item['extra']);

		$item['extra']['message'] = $message;
		$item['extra']['link'] = $link;
		$item['extra']['target'] = $target;

		return $item;
	}

	protected function _getDefaultTemplateTitle($contentType, $action)
	{
		return 'xcas_alert_banner';
	}


}